﻿
uses MathExtensions;
         
// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin    
   foreach var p in GeneratePrimes do begin
      if p = 2 then continue;
     // алгоритм деления в столбик для нахождения периода:
     var remainder := 1;
     var digits := new List<char>;
     var remainders := new Dictionary<int, int>;
     var position := 0;
     var periodFound := false;
     var periodStart := 0;
    
     while not periodFound and (position < 2000) do begin
        if remainders.ContainsKey(remainder) then begin
           periodFound := true;
           periodStart := remainders[remainder];
        end
        else begin
           remainders[remainder] := position;
           remainder := remainder * 10;
           digits.Add(char(ord('0') + remainder div p));
           remainder := remainder mod p;
           position := position + 1;
        end;
     end;

     if periodFound then begin      
      {
      // печатаем непериодическую часть
      for var i := 0 to periodStart - 1 do
        Write(digits[i]);
      
      // печатаем периодическую часть в скобках:
      Write('(');
      for var i := periodStart to digits.Count - 1 do
        Write(digits[i]);
      Write(')');
      }
         var periodLength := digits.Count - periodStart;
         //Writeln('   период: ', periodLength, ' цифр');
         //writeln;
         if periodLength = p - 1 then begin
            Write(' 1/', p:2);
            Writeln('  ✓ Циклическое простое!');
         end;
    {end
    
    else begin
      // Конечная дробь (для p=2,5)
      foreach var digit in digits do
        Write(digit);
      Writeln('   конечная дробь');
      }
      end;
      if p > 1100 then break;
   end;
   Writeln;   
end;


begin
   Writeln(' Циклические числа 2');
   Writeln;
       
   Solve;   
end.
